<?php
/*--------------------------------------------------------------------------------------------------
    AdditionalInfo.php 2020-3-20
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2016 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

/*--------------------------------------------------------------------------------------------------
    ModifierHint.php 2020-3-19
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2016 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\ProductModifiers\Modifiers\ValueObjects;


class AdditionalInfo
{
    /**
     * @var string
     */
    protected $pricePrefix;
    /**
     * @var float
     */
    protected $price;

    /**
     * ModifierHint constructor.
     * @param string $pricePrefix
     * @param float $price
     */
    public function __construct(string $pricePrefix, float $price )
    {

        $this->pricePrefix = $pricePrefix;
        $this->price = $price;
    }

    /**
     * @return string
     */
    public function pricePrefix(): string
    {
        return $this->pricePrefix;
    }

    /**
     * @return float
     */
    public function price(): float
    {
        return $this->price;
    }


}